/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var advanced_1 = require("./advanced");
var fs = require("fs");
var path = require("path");
var DEFAULT_REPORT_ON_FAILURE = false;
var DEFAULT_TIMEOUT = 500;
var ReportingChannel = (function () {
    function ReportingChannel(reportOnFailure, timeoutMS) {
        this._reportOnFailure = reportOnFailure !== undefined ? reportOnFailure : DEFAULT_REPORT_ON_FAILURE;
        this._timeout = timeoutMS !== undefined ? timeoutMS : DEFAULT_TIMEOUT;
    }
    Object.defineProperty(ReportingChannel.prototype, "reportOnFailure", {
        get: function () {
            return this._reportOnFailure;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ReportingChannel.prototype, "timeout", {
        get: function () {
            return this._timeout;
        },
        enumerable: true,
        configurable: true
    });
    ReportingChannel.prototype.registerListeners = function (reporter) {
    };
    ;
    return ReportingChannel;
}());
exports.ReportingChannel = ReportingChannel;
var ConsoleReporter = (function (_super) {
    __extends(ConsoleReporter, _super);
    function ConsoleReporter() {
        _super.call(this);
    }
    ConsoleReporter.prototype.report = function (error) {
        return new Promise(function (resolve, reject) {
            if (error.rawError.stack.length > 2000) {
                var shortened = error.rawError.stack.substr(0, 1000);
                shortened += "\n...shortened to avoid blocking while printing...\n" +
                    "...see other reporting methods for full stack...\n";
                shortened += error.rawError.stack.substring(error.rawError.stack.length - 1000);
                console.log(shortened);
            }
            else {
                console.log(error.rawError.stack);
            }
            console.log();
            resolve();
        });
    };
    return ConsoleReporter;
}(ReportingChannel));
exports.ConsoleReporter = ConsoleReporter;
var FileReporter = (function (_super) {
    __extends(FileReporter, _super);
    function FileReporter(filePath, fileName, stripStack) {
        _super.call(this);
        this.fileName = fileName;
        this.filePath = filePath;
        this.stripStack = stripStack;
    }
    FileReporter.prototype.report = function (error) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var fullPath = path.join(_this.filePath, _this.fileName);
            var content;
            if (_this.stripStack) {
                content = error.errorName + advanced_1.WATSON_LINE_BREAK;
                content += error.errorMessage + advanced_1.WATSON_LINE_BREAK;
                content += error.getVerboseStack() + advanced_1.WATSON_LINE_BREAK + advanced_1.WATSON_LINE_BREAK;
            }
            else {
                content = error.rawError.stack + "\n";
            }
            fs.appendFile(fullPath, content, {}, function (err) { if (err) {
                reject(err.stack);
            }
            else {
                resolve(fullPath);
            } });
        });
    };
    return FileReporter;
}(ReportingChannel));
exports.FileReporter = FileReporter;

// SIG // Begin signature block
// SIG // MIIh/QYJKoZIhvcNAQcCoIIh7jCCIeoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // 5qBy4WqRJwJpJUS0RYFJnlO9wulSd2qTtGMOk/O85Uig
// SIG // gguEMIIFDDCCA/SgAwIBAgITMwAAAU/nxmLJRvSpfwAA
// SIG // AAABTzANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDEwMB4XDTE2MTExNzIxNTkxNFoX
// SIG // DTE4MDIxNzIxNTkxNFowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBALSJkIp2DKzFPaG8gejXUAi7
// SIG // WmmnrsfMuFu9OA8hUUYII9G9Iplztyjv9werK/lI96UU
// SIG // BalNJBttYZacg50zwCx5mfBd8+zVRN+lzVn6dq0GP8ZK
// SIG // A+bqLZQQwmZv/WLQUIrRIpEjl2U0ocSaAl6S4rh8KHjC
// SIG // XuNG98rvOFeIrFYGWMqYG8eo1142rppFMOO2tz0Ywqcn
// SIG // sHlNU9gy5najUCr2P7q7QR4khk2Ym3qe9izivJBgZfuW
// SIG // afrgE2jiiSoudRidwm24IfSZXip/MaCnDczvTxFu/klC
// SIG // TmHeN8srnkDvzqtecAhzpXJ7t0bOWzJTXYo5UW+w16h4
// SIG // 3aMob17uQh8CAwEAAaOCAXswggF3MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjc9BgEGCCsGAQUFBwMDMB0GA1UdDgQWBBSS
// SIG // DqERcbYvVQ3DD/TJXHQuWgxqvzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwODY1
// SIG // K2I0YjEyODc4LWUyOTMtNDNlOS1iMjFlLTdkMzA3MTlk
// SIG // NDUyZjAfBgNVHSMEGDAWgBTm/F97uyIAWORyTrX0IXQj
// SIG // MubvrDBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3Js
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9N
// SIG // aWNDb2RTaWdQQ0FfMjAxMC0wNy0wNi5jcmwwWgYIKwYB
// SIG // BQUHAQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNp
// SIG // Z1BDQV8yMDEwLTA3LTA2LmNydDAMBgNVHRMBAf8EAjAA
// SIG // MA0GCSqGSIb3DQEBCwUAA4IBAQARwLlqQzX+hbE4gA24
// SIG // dHUsjXFJuDxB7S294gY2kHYrieW2gemG4xiMlpMyQqen
// SIG // 9rc0JTnQxnpD6tt3cMzU6ULrqMVVAnV4ntgQvgcbypRj
// SIG // +zwPce7UVWfXKfZqvwe85Y+C6vih4nMzPxSSXqG6ZVc3
// SIG // RYWAXNYsxos8aoejBxHL7NlxOCA1JD1UvcxVifR3EJvl
// SIG // maoPrsY8jp/aAE/PfeGzwCD3UjH3IkjVYY1/JgIZfYPM
// SIG // YZMq3bjc4gizp9/hBHdgyPSsNcsx5Wx1UcU3exNqTpVr
// SIG // j0CeyE0+rr1ZxSDWwnitt2RbO9DAFXA0FOXFnqYcx/T/
// SIG // 9stIweKN827OqrSgMIIGcDCCBFigAwIBAgIKYQxSTAAA
// SIG // AAAAAzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMC
// SIG // VVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcT
// SIG // B1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jw
// SIG // b3JhdGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3Qg
// SIG // Q2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTAwHhcNMTAw
// SIG // NzA2MjA0MDE3WhcNMjUwNzA2MjA1MDE3WjB+MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQSAyMDEwMIIBIjANBgkqhkiG
// SIG // 9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6Q5kUHlntcTj/QkA
// SIG // TJ6UrPdWaOpE2M/FWE+ppXZ8bUW60zmStKQe+fllguQX
// SIG // 0o/9RJwI6GWTzixVhL99COMuK6hBKxi3oktuSUxrFQfe
// SIG // 0dLCiR5xlM21f0u0rwjYzIjWaxeUOpPOJj/s5v40mFfV
// SIG // HV1J9rIqLtWFu1k/+JC0K4N0yiuzO0bj8EZJwRdmVMkc
// SIG // vR3EVWJXcvhnuSUgNN5dpqWVXqsogM3Vsp7lA7Vj07IU
// SIG // yMHIiiYKWX8H7P8O7YASNUwSpr5SW/Wm2uCLC0h31oVH
// SIG // 1RC5xuiq7otqLQVcYMa0KlucIxxfReMaFB5vN8sZM4Bq
// SIG // iU2jamZjeJPVMM+VHwIDAQABo4IB4zCCAd8wEAYJKwYB
// SIG // BAGCNxUBBAMCAQAwHQYDVR0OBBYEFOb8X3u7IgBY5HJO
// SIG // tfQhdCMy5u+sMBkGCSsGAQQBgjcUAgQMHgoAUwB1AGIA
// SIG // QwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/
// SIG // MB8GA1UdIwQYMBaAFNX2VsuP6KJcYmjRPZSQW9fOmhjE
// SIG // MFYGA1UdHwRPME0wS6BJoEeGRWh0dHA6Ly9jcmwubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1Jv
// SIG // b0NlckF1dF8yMDEwLTA2LTIzLmNybDBaBggrBgEFBQcB
// SIG // AQROMEwwSgYIKwYBBQUHMAKGPmh0dHA6Ly93d3cubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljUm9vQ2VyQXV0
// SIG // XzIwMTAtMDYtMjMuY3J0MIGdBgNVHSAEgZUwgZIwgY8G
// SIG // CSsGAQQBgjcuAzCBgTA9BggrBgEFBQcCARYxaHR0cDov
// SIG // L3d3dy5taWNyb3NvZnQuY29tL1BLSS9kb2NzL0NQUy9k
// SIG // ZWZhdWx0Lmh0bTBABggrBgEFBQcCAjA0HjIgHQBMAGUA
// SIG // ZwBhAGwAXwBQAG8AbABpAGMAeQBfAFMAdABhAHQAZQBt
// SIG // AGUAbgB0AC4gHTANBgkqhkiG9w0BAQsFAAOCAgEAGnTv
// SIG // V08pe8QWhXi4UNMi/AmdrIKX+DT/KiyXlRLl5L/Pv5PI
// SIG // 4zSp24G43B4AvtI1b6/lf3mVd+UC1PHr2M1OHhthosJa
// SIG // IxrwjKhiUUVnCOM/PB6T+DCFF8g5QKbXDrMhKeWloWmM
// SIG // IpPMdJjnoUdD8lOswA8waX/+0iUgbW9h098H1dlyACxp
// SIG // hnY9UdumOUjJN2FtB91TGcun1mHCv+KDqw/ga5uV1n0o
// SIG // UbCJSlGkmmzItx9KGg5pqdfcwX7RSXCqtq27ckdjF/qm
// SIG // 1qKmhuyoEESbY7ayaYkGx0aGehg/6MUdIdV7+QIjLcVB
// SIG // y78dTMgW77Gcf/wiS0mKbhXjpn92W9FTeZGFndXS2z1z
// SIG // NfM8rlSyUkdqwKoTldKOEdqZZ14yjPs3hdHcdYWch8Za
// SIG // V4XCv90Nj4ybLeu07s8n07VeafqkFgQBpyRnc89NT7be
// SIG // BVaXevfpUk30dwVPhcbYC/GO7UIJ0Q124yNWeCImNr7K
// SIG // sYxuqh3khdpHM2KPpMmRM19xHkCvmGXJIuhCISWKHC1g
// SIG // 2TeJQYkqFg/XYTyUaGBS79ZHmaCAQO4VgXc+nOBTGBpQ
// SIG // HTiVmx5mMxMnORd4hzbOTsNfsvU9R1O24OXbC2E9KteS
// SIG // LM43Wj5AQjGkHxAIwlacvyRdUQKdannSF9PawZSOB3sl
// SIG // cUSrBmrm1MbfI5qWdcUxghXRMIIVzQIBATCBlTB+MQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3Nv
// SIG // ZnQgQ29kZSBTaWduaW5nIFBDQSAyMDEwAhMzAAABT+fG
// SIG // YslG9Kl/AAAAAAFPMA0GCWCGSAFlAwQCAQUAoIHAMBkG
// SIG // CSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwGCisGAQQB
// SIG // gjcCAQsxDjAMBgorBgEEAYI3AgEVMC8GCSqGSIb3DQEJ
// SIG // BDEiBCDVjKKWhIcgHNzZ7viJNZDMAX0FzDEG0uWtuDes
// SIG // AW1q1TBUBgorBgEEAYI3AgEMMUYwRKAqgCgAcgBlAHAA
// SIG // bwByAHQAaQBuAGcALQBjAGgAYQBuAG4AZQBsAC4AagBz
// SIG // oRaAFGh0dHA6Ly9taWNyb3NvZnQuY29tMA0GCSqGSIb3
// SIG // DQEBAQUABIIBADLkZK/jnKznL2w+wwvDO4N8Va+zc2tQ
// SIG // fszSEQhLLr0kN2h8kVOfpRgxgc8wUCfBhGF3B/MLYS8G
// SIG // YexOrdlknxvaL3cX1NFoWMkAt0rssrVLr0ZKUGBBA+P/
// SIG // pS0TJ8dWI15DB5c35YL5OiVpS6Cz8A/QBgnduHwmnMc+
// SIG // QS4ElBd27w7TKLU3rJcOtx2i8xnN8RDSgdfyQWM1zNP2
// SIG // MSjf4E2oPeWayusLvxkmwl+SCIvzYwiu7hcX8jXsHnG9
// SIG // P5+ngcoosnakjhQboMMT7ueIDTuFjZnPHiLEiHph95+K
// SIG // knr1YaZ/yVWQJc7S/dpd3GIxpHB+5faZCzWoIhnoyBD4
// SIG // wYShghNJMIITRQYKKwYBBAGCNwMDATGCEzUwghMxBgkq
// SIG // hkiG9w0BBwKgghMiMIITHgIBAzEPMA0GCWCGSAFlAwQC
// SIG // AQUAMIIBPAYLKoZIhvcNAQkQAQSgggErBIIBJzCCASMC
// SIG // AQEGCisGAQQBhFkKAwEwMTANBglghkgBZQMEAgEFAAQg
// SIG // tRDnnQ4xdyeu64khUFsYCGRzgNe+zRtksOnVGU27pQ4C
// SIG // Blg/MUo6rRgSMjAxNjEyMjgwMDU4MDAuODVaMAcCAQGA
// SIG // AgH0oIG5pIG2MIGzMQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0w
// SIG // CwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERT
// SIG // RSBFU046RjUyOC0zNzc3LThBNzYxJTAjBgNVBAMTHE1p
// SIG // Y3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2Wggg7NMIIG
// SIG // cTCCBFmgAwIBAgIKYQmBKgAAAAAAAjANBgkqhkiG9w0B
// SIG // AQsFADCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEyMDAGA1UE
// SIG // AxMpTWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0
// SIG // aG9yaXR5IDIwMTAwHhcNMTAwNzAxMjEzNjU1WhcNMjUw
// SIG // NzAxMjE0NjU1WjB8MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYw
// SIG // JAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Eg
// SIG // MjAxMDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAKkdDbx3EYo6IOz8E5f1+n9plGt0VBDVpQoAgoX7
// SIG // 7XxoSyxfxcPlYcJ2tz5mK1vwFVMnBDEfQRsalR3OCROO
// SIG // fGEwWbEwRA/xYIiEVEMM1024OAizQt2TrNZzMFcmgqNF
// SIG // DdDq9UeBzb8kYDJYYEbyWEeGMoQedGFnkV+BVLHPk0yS
// SIG // wcSmXdFhE24oxhr5hoC732H8RsEnHSRnEnIaIYqvS2SJ
// SIG // UGKxXf13Hz3wV3WsvYpCTUBR0Q+cBj5nf/VmwAOWRH7v
// SIG // 0Ev9buWayrGo8noqCjHw2k4GkbaICDXoeByw6ZnNPOcv
// SIG // RLqn9NxkvaQBwSAJk3jN/LzAyURdXhacAQVPIk0CAwEA
// SIG // AaOCAeYwggHiMBAGCSsGAQQBgjcVAQQDAgEAMB0GA1Ud
// SIG // DgQWBBTVYzpcijGQ80N7fEYbxTNoWoVtVTAZBgkrBgEE
// SIG // AYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8EBAMCAYYw
// SIG // DwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAWgBTV9lbL
// SIG // j+iiXGJo0T2UkFvXzpoYxDBWBgNVHR8ETzBNMEugSaBH
// SIG // hkVodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2Ny
// SIG // bC9wcm9kdWN0cy9NaWNSb29DZXJBdXRfMjAxMC0wNi0y
// SIG // My5jcmwwWgYIKwYBBQUHAQEETjBMMEoGCCsGAQUFBzAC
// SIG // hj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2Nl
// SIG // cnRzL01pY1Jvb0NlckF1dF8yMDEwLTA2LTIzLmNydDCB
// SIG // oAYDVR0gAQH/BIGVMIGSMIGPBgkrBgEEAYI3LgMwgYEw
// SIG // PQYIKwYBBQUHAgEWMWh0dHA6Ly93d3cubWljcm9zb2Z0
// SIG // LmNvbS9QS0kvZG9jcy9DUFMvZGVmYXVsdC5odG0wQAYI
// SIG // KwYBBQUHAgIwNB4yIB0ATABlAGcAYQBsAF8AUABvAGwA
// SIG // aQBjAHkAXwBTAHQAYQB0AGUAbQBlAG4AdAAuIB0wDQYJ
// SIG // KoZIhvcNAQELBQADggIBAAfmiFEN4sbgmD+BcQM9naOh
// SIG // IW+z66bM9TG+zwXiqf76V20ZMLPCxWbJat/15/B4vceo
// SIG // niXj+bzta1RXCCtRgkQS+7lTjMz0YBKKdsxAQEGb3FwX
// SIG // /1z5Xhc1mCRWS3TvQhDIr79/xn/yN31aPxzymXlKkVIA
// SIG // rzgPF/UveYFl2am1a+THzvbKegBvSzBEJCI8z+0DpZaP
// SIG // WSm8tv0E4XCfMkon/VWvL/625Y4zu2JfmttXQOnxzplm
// SIG // kIz/amJ/3cVKC5Em4jnsGUpxY517IW3DnKOiPPp/fZZq
// SIG // kHimbdLhnPkd/DjYlPTGpQqWhqS9nhquBEKDuLWAmyI4
// SIG // ILUl5WTs9/S/fmNZJQ96LjlXdqJxqgaKD4kWumGnEcua
// SIG // 2A5HmoDF0M2n0O99g/DhO3EJ3110mCIIYdqwUB5vvfHh
// SIG // AN/nMQekkzr3ZUd46PioSKv33nJ+YWtvd6mBy6cJrDm7
// SIG // 7MbL2IK0cs0d9LiFAR6A+xuJKlQ5slvayA1VmXqHczsI
// SIG // 5pgt6o3gMy4SKfXAL1QnIffIrE7aKLixqduWsqdCosnP
// SIG // GUFN4Ib5KpqjEWYw07t0MkvfY3v1mYovG8chr1m1rtxE
// SIG // PJdQcdeh0sVV42neV8HR3jDA/czmTfsNv11P6Z0eGTgv
// SIG // vM9YBS7vDaBQNdrvCScc1bN+NR4Iuto229Nfj950iEkS
// SIG // MIIE2jCCA8KgAwIBAgITMwAAALCG6ZIgCl3q+AAAAAAA
// SIG // sDANBgkqhkiG9w0BAQsFADB8MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFt
// SIG // cCBQQ0EgMjAxMDAeFw0xNjA5MDcxNzU2NTZaFw0xODA5
// SIG // MDcxNzU2NTZaMIGzMQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0w
// SIG // CwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERT
// SIG // RSBFU046RjUyOC0zNzc3LThBNzYxJTAjBgNVBAMTHE1p
// SIG // Y3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2UwggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDw5fCNlFmp
// SIG // mtdsCQd3FCFZXbc9eLg1rfUwMf/O4f/W6RrJg5gj+5AQ
// SIG // wZLsOrxQbJC9XPFrrUyi9WGlh+EprKM8Et9/xACCzr20
// SIG // Cl/LuduatxktWu0HAK1U/TOs9vgSJEokZ1fauEuhrA+A
// SIG // +Tm9IA21p8QsS/GhVubyLye5JsEzJdkrDDByUIRrkmqV
// SIG // jPL6CE24LiTVQ9Pc6/N0aoizybRg3MllrV8J5RFqFDTB
// SIG // 5FcGEkbmoL2EWiRCQ/a89CxVmVqNs4imqhKUIr6GtUqJ
// SIG // jKpHsKDFHxuPnPBibVSdMtOpxJtT6blyO78Xnq9YXJ3G
// SIG // K1Ahu9iWzDbvjaZz2a27Q3AVAgMBAAGjggEbMIIBFzAd
// SIG // BgNVHQ4EFgQU/KgHUtnvKf6YQzwVXHRet39z4K8wHwYD
// SIG // VR0jBBgwFoAU1WM6XIoxkPNDe3xGG8UzaFqFbVUwVgYD
// SIG // VR0fBE8wTTBLoEmgR4ZFaHR0cDovL2NybC5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWljVGltU3Rh
// SIG // UENBXzIwMTAtMDctMDEuY3JsMFoGCCsGAQUFBwEBBE4w
// SIG // TDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNUaW1TdGFQQ0FfMjAx
// SIG // MC0wNy0wMS5jcnQwDAYDVR0TAQH/BAIwADATBgNVHSUE
// SIG // DDAKBggrBgEFBQcDCDANBgkqhkiG9w0BAQsFAAOCAQEA
// SIG // kv2A93W9ZZA+F83VFYPFjgKRO6xOfWDvjzkGk5DjD6pF
// SIG // PYk/Av3sb7hQkAlshNI3IZmxwYZ2HeQNxo7/GOCi+ka1
// SIG // hXd0bk4MREXQvNK2BH5wSw/WqwdpVkp2ZOj5qkejo4bc
// SIG // 9M9EuEkQW2eP0dp5rjrdh1MG6I9q/H/X5KOGRRUNkWIi
// SIG // OpBK49hoAUnJLQ5reGwRAvSPTRFgc6gDIQ2X4w9ydbv9
// SIG // 6A646/wgQZ2Ok/3FM3M+OXq9ajQeOUdiEbUc71f0c4Nx
// SIG // n6gUZb7kA45NbcQBMxt+V+yh8xyXqTin9Kg6OfmJNfxd
// SIG // oyKuCr2NDKsxEm7pvWEW7PQZOiSFYl+psqGCA3YwggJe
// SIG // AgEBMIHjoYG5pIG2MIGzMQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVy
// SIG // IERTRSBFU046RjUyOC0zNzc3LThBNzYxJTAjBgNVBAMT
// SIG // HE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2WiJQoB
// SIG // ATAJBgUrDgMCGgUAAxUAvIT7nVsS2sc2hTuIZp6jFhjV
// SIG // zByggcIwgb+kgbwwgbkxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // DTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIg
// SIG // TlRTIEVTTjo1N0Y2LUMxRTAtNTU0QzErMCkGA1UEAxMi
// SIG // TWljcm9zb2Z0IFRpbWUgU291cmNlIE1hc3RlciBDbG9j
// SIG // azANBgkqhkiG9w0BAQUFAAIFANwNhAgwIhgPMjAxNjEy
// SIG // MjgwMDIxMjhaGA8yMDE2MTIyOTAwMjEyOFowdDA6Bgor
// SIG // BgEEAYRZCgQBMSwwKjAKAgUA3A2ECAIBADAHAgEAAgID
// SIG // vzAHAgEAAgIX6jAKAgUA3A7ViAIBADA2BgorBgEEAYRZ
// SIG // CgQCMSgwJjAMBgorBgEEAYRZCgMBoAowCAIBAAIDFuNg
// SIG // oQowCAIBAAIDB6EgMA0GCSqGSIb3DQEBBQUAA4IBAQAy
// SIG // uqUJMJCuOVNvCziwOxZ18Vganx0oNuZT5/aNMxCIdUQd
// SIG // YWGXRZ7gid4VNlI0kWVRHBg2R54eGMIzyDAu4NjhUbd3
// SIG // YI9jS+eTLuzeSHN+exSNYIUG47WDFu2OZ1IvwVtwnV01
// SIG // 2Tn12dYeuq+fZEsJ4wZai/QcGHhVSgziwl2OOPu+eLrT
// SIG // Cvy8km2fNRWATfAkpMh5RKhWPgRzX6VL36qn8vg7qibz
// SIG // zOPj6vmjG9g6R8HjniSg+Is256ScHxHsZENa4dbn6kD/
// SIG // WVGURxTABfUEYGTY9hBEIfNjOqy+dB+G4R8k8ApDMSqT
// SIG // 4J/MCOoi2dXO1EJsIs6whnhlodJS3BITMYIC9TCCAvEC
// SIG // AQEwgZMwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UE
// SIG // AxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAC
// SIG // EzMAAACwhumSIApd6vgAAAAAALAwDQYJYIZIAWUDBAIB
// SIG // BQCgggEyMBoGCSqGSIb3DQEJAzENBgsqhkiG9w0BCRAB
// SIG // BDAvBgkqhkiG9w0BCQQxIgQgAfu3JKKWkBG1nN+zBBm3
// SIG // WE2jvD4F2yhtBAC3qJkV558wgeIGCyqGSIb3DQEJEAIM
// SIG // MYHSMIHPMIHMMIGxBBS8hPudWxLaxzaFO4hmnqMWGNXM
// SIG // HDCBmDCBgKR+MHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQI
// SIG // EwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4w
// SIG // HAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAk
// SIG // BgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAy
// SIG // MDEwAhMzAAAAsIbpkiAKXer4AAAAAACwMBYEFIrsUSfN
// SIG // p+vcbANMs4cNSbj79izoMA0GCSqGSIb3DQEBCwUABIIB
// SIG // ACvBv6AJPUauPsU/3PCvc+MJBkrdsDGFG9TfNrJAym86
// SIG // qlZcy7EK9IjsnNiPv8Kb79QdR4VJwwLQ/T6ZPoB0UYmZ
// SIG // G2BImw9lKLpTHdb1Tvkg2cnYM1zleJEAP1P3h04jml7b
// SIG // 78kPVhylX3h5nGtKdV2nCXMCJCxdpOJOfpgP+Jk+p3cJ
// SIG // SoRBA15sDd7xbdIa57BjFQ5ozYwNj164kom0wGFuSkP1
// SIG // x8bFSQGhCYzEngq/PJRQ0gqVQ3lZJgTBAgWZVqLv4eW6
// SIG // outcp+++mel+y7t5eGumIUmyZopmUSRphPAX/KTnFa8j
// SIG // g4nHZpQ3xQcPt7vZwKM9qvZ9fsdqhX67lJE=
// SIG // End signature block
